// Point.java

import java.util.HashMap;
import java.util.Map;

class Point
{
   private int x, y;
   Point(int x, int y)
   {
      this.x = x;
      this.y = y;
   }
   int getX()
   {
      return x;
   }
   int getY()
   {
      return y;
   }
   @Override
   public boolean equals(Object o)
   {
      if (!(o instanceof Point))
         return false;
      Point p = (Point) o;
      return p.x == x && p.y == y;
   }
   @Override
   public int hashCode()
   {
      int hashCode = 19;
      int hc = x;
      hashCode = hashCode*31+hc;
      hc = y;
      hashCode = hashCode*31+hc;
      return hc;
   }
   public static void main(String[] args)
   {
      Point p1 = new Point(10, 20);
      Point p2 = new Point(20, 30);
      Point p3 = new Point(10, 20);
      // Test zwrotności
      System.out.println(p1.equals(p1)); // Wyjście: true
      // Test symetrii
      System.out.println(p1.equals(p2)); // Wyjście: false
      System.out.println(p2.equals(p1)); // Wyjście: false
      // Test przechodniości
      System.out.println(p2.equals(p3)); // Wyjście: false
      System.out.println(p1.equals(p3)); // Wyjście: true
      // Test na wartość null
      System.out.println(p1.equals(null)); // Wyjście: false
      // Dodatkowy test wykazujący przydatność operatora instanceof
      System.out.println(p1.equals("abc")); // Wyjście: false
      Map<Point, String> map = new HashMap<Point, String>();
      map.put(p1, "pierwszy punkt");
      System.out.println(map.get(p1)); // Wyjście: pierwszy punkt
      System.out.println(map.get(new Point(10, 20))); // Wyjście: pierwszy punkt 
   }
}

