// TempConversion.java

public enum TempConversion
{
   C2F("Stopnie Celsjusza na stopnie Fahrenheita")
   {
      @Override
      public double convert(double value)
      {
         return value*9.0/5.0+32.0;
      }
   },
   F2C("Stopnie Fahrenheita na stopnie Celsjusza")
   {
      @Override
      public double convert(double value)
      {
         return (value-32.0)*5.0/9.0;
      }
   };

   TempConversion(String desc)
   {
      this.desc = desc;
   }
   private String desc;
   @Override
   public String toString()
   {
      return desc;
   }
   public abstract double convert(double value);
   public static void main(String[] args)
   {
      System.out.println(C2F + " dla 100.0 stopni = " +
                         C2F.convert(100.0));
      System.out.println(F2C + " dla 98.6 stopni = " +
                         F2C.convert(98.6));
   }
}
