// Lotto649.java

public class Lotto649
{
   public static void main(String[] args)
   {
      // W grze Lotto 649 naley wybra 6 unikatowych liczb.
      int[] selectedNumbers = new int[6];

      // Przypisanie kademu elementowi tablicy selectedNumber unikatowej,
      // losowo wybranej liczb z przedziau od 1 do 49 (wcznie).
      for (int slot = 0; slot < selectedNumbers.length; slot++)
      {
           int num;

           // Wylosowanie liczby z przedziau od 1 do 49. Bdzie to liczba wybrana,
           // jeeli tylko nie zostaa wybrana ju wczeniej.
           try_again:
           do
           {
               num = rnd(49)+1;
               for (int i = 0; i < slot; i++)
                    if (selectedNumbers[i] == num)
                        continue try_again;
               break;
           }
           while (true);

           // Przypisanie wybranej liczby odpowiedniemu elementowi.
           selectedNumbers[slot] = num;
      }

      // Ustawienie wszystkich wybranych liczb w porzdku rosncym oraz wywietlenie tych liczb.
      sort(selectedNumbers);
      for (int i = 0; i < selectedNumbers.length; i++)
           System.out.print(selectedNumbers[i] + " ");
   }
   private static int rnd(int limit)
   {
      // Metoda zwraca losow liczb (bardziej precyzyjnie: liczb pseudolosow)
      // z przedziau od 0 do limit-1 wcznie.
      assert limit > 1: "limit = " + limit;
      return (int)(Math.random()*limit);
   }
   private static void sort(int[] x)
   {
      // Metoda porzdkuje liczby w przekazanej tablicy w kolejnoci rosncej.
      for (int pass = 0; pass < x.length-1; pass++)
         for (int i = x.length-1; i > pass; i--)
            if (x[i] < x[pass])
            {
               int temp = x[i];
               x[i] = x[pass];
               x[pass] = temp;
            }
   }
}
