// JavaQuiz.java

public class JavaQuiz
{
   static QuizEntry[] quizEntries =
   {
      new QuizEntry("Jak pierwotnie nazywała się Java?",
                    new String[] { "Oak", "Duke", "J", "Żadne z wymienionych" },
                    'A'),
      new QuizEntry("Które z wymienionych zastrzeżonych słów jest też literałem?",
                    new String[] { "for", "long", "true", "enum" },
                    'C'),
      new QuizEntry("Którą instrukcję przypomina operator warunku (?:)?",
                    new String[] { "switch", "if-else", "if", "while" },
                    'B')
   };
   public static void main(String[] args)
   {
      // Wypełnienie listy pytaniami testu.
      List<QuizEntry> quiz = new ArrayList<QuizEntry>();
      for (QuizEntry entry: quizEntries)
         quiz.add(entry);
      // Przeprowadzenie testu.
      System.out.println("Java Quiz");
      System.out.println("---------\n");
      Iterator<QuizEntry> iter = quiz.iterator();
      while (iter.hasNext())
      {
         QuizEntry qe = iter.next();
         System.out.println(qe.getQuestion());
         String[] choices = qe.getChoices();
         for (int i = 0; i < choices.length; i++)
            System.out.println("  " + (char) ('A'+i) + ": " + choices[i]);
         int choice = -1;
         while (choice < 'A' || choice > 'A'+choices.length)
         {
            System.out.print("Podaj odpowiedź: ");
            try
            {
               choice = System.in.read();
               // Usunięcie wszystkich niepotrzebnych znaków aż do znaku końca wiersza,
               // aby uniknąć zwrócenia ich przez kolejne wywołania metody System.in.read().
               while (System.in.read() != '\n');
               choice = Character.toUpperCase((char) choice);
            }
            catch (java.io.IOException ioe)
            {
            }
         }
         if (choice == qe.getAnswer())
            System.out.println("Prawidłowo!\n");
         else
            System.out.println("Niestety nie!\n");
      }
   }
}
