// RegExDemo.java

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegExDemo
{
   public static void main(String[] args)
   {
      if (args.length != 2)
      {
         System.err.println("sposób wywołania: java RegExDemo wyrażenie_regularne ciąg_wejściowy");
         return;
      }
      try
      {
         System.out.println("wyrażenie regularne (regex) = " + args[0]);
         System.out.println("ciąg wejściowy (input) = " + args[1]);
         Pattern p = Pattern.compile(args[0]);
         Matcher m = p.matcher(args[1]);
         while (m.find())
            System.out.println("Zlokalizowano ciąg [" + m.group()
                               + "] rozpoczynający się w " + m.start()
                               + " i kończący w " + (m.end()-1));
      }
      catch (PatternSyntaxException pse)
      {
         System.err.println("Błędne wyrażenie: " + pse.getMessage());
         System.err.println("Opis: " + pse.getDescription());
         System.err.println("Indeks: " + pse.getIndex());
         System.err.println("Nieprawidłowy wzorzec: " + pse.getPattern());
      }
   }
}
