// Deck.java

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 *  Symulacja talii kart.
 *
 *  @author Jeff Friesen
 */
public class Deck
{
   private Card[] cards = new Card[]
   {
      Card.AS_TREFL,
      Card.DWJKA_TREFL,
      Card.TRJKA_TREFL,
      Card.CZWRKA_TREFL,
      Card.PITKA_TREFL,
      Card.SZSTKA_TREFL,
      Card.SIDEMKA_TREFL,
      Card.SEMKA_TREFL,
      Card.DZIEWITKA_TREFL,
      Card.DZIESITKA_TREFL,
      Card.WALET_TREFL,
      Card.KRLOWA_TREFL,
      Card.KRL_TREFL,
      Card.AS_KARO,
      Card.DWJKA_KARO,
      Card.TRJKA_KARO,
      Card.CZWRKA_KARO,
      Card.PITKA_KARO,
      Card.SZSTKA_KARO,
      Card.SIDEMKA_KARO,
      Card.SEMKA_KARO,
      Card.DZIEWITKA_KARO,
      Card.DZIESITKA_KARO,
      Card.WALET_KARO,
      Card.KRLOWA_KARO,
      Card.KRL_KARO,
      Card.AS_KIER,
      Card.DWJKA_KIER,
      Card.TRJKA_KIER,
      Card.CZWRKA_KIER,
      Card.PITKA_KIER,
      Card.SZSTKA_KIER,
      Card.SIDEMKA_KIER,
      Card.SEMKA_KIER,
      Card.DZIEWITKA_KIER,
      Card.DZIESITKA_KIER,
      Card.WALET_KIER,
      Card.KRLOWA_KIER,
      Card.KRL_KIER,
      Card.AS_PIK,
      Card.DWJKA_PIK,
      Card.TRJKA_PIK,
      Card.CZWRKA_PIK,
      Card.PITKA_PIK,
      Card.SZSTKA_PIK,
      Card.SIDEMKA_PIK,
      Card.SEMKA_PIK,
      Card.DZIEWITKA_PIK,
      Card.DZIESITKA_PIK,
      Card.WALET_PIK,
      Card.KRLOWA_PIK,
      Card.KRL_PIK
   };
   private List<Card> deck;
   /**
    *  Tworzy tali <code>Deck</code> 52 kart <code>Card</code>.
    *  Tasuje obiekty kart.
    */
   public Deck()
   {
      deck = new ArrayList<Card>();
      for (int i = 0; i < cards.length; i++)
      {
         deck.add(cards[i]);
         cards[i] = null;
      }
      Collections.shuffle(deck);
   }
   /**
    *  Wydaje kart <code>Card</code> z gry talii <code>Deck</code>.
    *
    *  @return obiekt karty <code>Card</code> znajdujcej si 
    *  na grze talii <code>Deck</code>
    */
   public Card deal()
   {
      return deck.remove(0);
   }
   /**
    *  Zwraca wskanik, ktry pokazuje, czy talia <code>Deck</code> jest pusta.
    *
    *  @return true jeli talia <code>Deck</code> nie zawiera adnej karty <code>Card</code>;
    *  w przeciwnym razie false
    */
   public boolean isEmpty()
   {
      return deck.isEmpty();
   }
   /**
    *  Zwraca kart <code>Card</code> na d talii <code>Deck</code>.
    *
    *  @param card obiekt karty <code>Card</code>, ktra zostaa zwrcona
    */
   public void putBack(Card card)
   {
      deck.add(card);
   }
   /**
    *  Tasuje tali <code>Deck</code>.
    */
   public void shuffle()
   {
      Collections.shuffle(deck);
   }
}
