/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 9. Obsuga wartoci null za pomoc typw Optional
 *
 * Listing 9.6. Sprawdzanie wartoci opcyjnych
 */

import java.util.Optional;

Optional<String> maybeValue = Optional.ofNullable(null);

// WERSJA ROZWLEKA
if (maybeValue.isPresent()) {
    var value = maybeValue.orElseThrow();
    System.out.println(value);
} else {
    System.out.println("Nie znaleziono adnej wartoci!");
}

// WERSJA ZWIZA
maybeValue.ifPresentOrElse(System.out::println,
                           () -> System.out.println("Nie znaleziono adnej wartoci!"));
