/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 5. Praca z rekordami
 */

// WSPӣDZIELONY INTERFEJS DEFINIUJCY KOMPONENTY
// ORAZ METODA DOMYLNA
public interface Origin {

    int x();
    int y();

    default String origin() {
        return String.format("(%d/%d)", x(), y());
    }
}


// KOLEJNY WSPӣDZIELONY INTERFEJS
public interface Area {
    float area();
}


// RECORD IMPLEMENTUJCY PIERWSZY WSPӣDZIELONY INTERFEJS
// Z WYPENIAJCYMI GO KOMPONENTAMI

public record Point(int x, int y) implements Origin {
    // BRAK CIAA
}


// RECORDY IMPLEMENTUJCE OBA WSPӣDZIELONE INTERFEJSY
// WYMAGA TO JEDNAK ZAPEWNIENIA IMPLEMENTACJI
// DLA "float area()"

public record Rectangle(int x, int y, int width, int height)
    implements Origin, Area {

    public float area() {
        return (float) (width() * height());
    }
}


public record Circle(int x, int y, int radius)
    implements Origin, Area {

    public float area() {
        return (float) Math.PI * radius() * radius();
    }
}
