/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 5. Praca z rekordami
 */

public record Origin(int x, int y) {
    // Dodatkowy konstruktor pomocniczy
    public Origin() {
        this(0, 0);
    }
}


public record Rectangle(Origin origin, int width, int height) {

    // Wiele konstruktorw pomocniczych
    
    public Rectangle(int x, int y, int width, int height) {
        this(new Origin(x, y), width, height);
    }

    public Rectangle(int width, int height) {
        this(new Origin(), width, height);
    }
}

var rectangle1 = new Rectangle(300, 400);
var rectangle2 = new Rectangle(new Origin(), 300, 400);
var rectangle3 = new Rectangle(new Origin(0, 0), 300, 400);

rectangle1.equals(rectangle2);
rectangle2.equals(rectangle3);
rectangle3.equals(rectangle1);
