/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 5. Praca z rekordami
 *
 * Listing 5.2. Prosty niemutowalny typ User
 */

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class PointSerialization {

    record Point(int x, int y) implements Serializable {
        // EWOLUCJA 1
        // record Point(int x, int y, int z) implements Serializable {

        // EWOLUCJA 2
        // record Point(int z, int y, int x) implements Serializable {
    }

    public static void main(String... args) throws ClassNotFoundException, IOException {

        // Wykonentuj var point i blok try, aby uruchomi "EWOLUCJA 1" i "EWOLUCJA 2"
        var point = new Point(23, 42);
        try (var out = new ObjectOutputStream(new FileOutputStream("point.data"))) {
            out.writeObject(point);
        }

        // EWOLUCJA 1 / EWOLUCJA 2
        // var in = new ObjectInputStream(new FileInputStream("point.data"));
        // var point = in.readObject();
        // System.out.println(point);
    }
}