package com.beliefdrivendesign.afatj.decorator_pattern.oo;

import com.beliefdrivendesign.afatj.decorator_pattern.shared.*;

public class Main {

    public static void main(String... args) {

        // Café con Leche

        CoffeeMaker coffeeMaker = new BlackCoffeeMaker();
        CoffeeMaker decoratedCoffeeMaker = new AddMilkDecorator(coffeeMaker, new MilkCarton());

        System.out.println("Składniki do Café con Leche: " + decoratedCoffeeMaker.getIngredients());

        // Dodawanie cukru

        CoffeeMaker lastDecoratedCoffeeMaker = new AddSugarDecorator(decoratedCoffeeMaker);

        System.out.println("Składniki po dodaniu cukru: " + lastDecoratedCoffeeMaker.getIngredients());
    }
}
