/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 11. Ewaluacja leniwa
 *
 * Listing 11.4. Aktualizowanie obiektu User za pomoc wyraenia lambda
 */

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;


record Role(String name) {}

record User(List<Role> roles) {}

class DAO {
    public List<Role> loadAllAvailableRoles() {
        return List.of(new Role("admin"),
                       new Role("go"));
    }
}

User updateUser(User user,
                Supplier<List<Role>> availableRolesFn) {
    return new User(availableRolesFn.get());
}


var dao = new DAO();

// SPOSB UYCIA

var user = new User(Collections.emptyList());

var updatedUser = updateUser(user, dao::loadAllAvailableRoles);
