/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 10. Obsuga wyjtkw funkcyjnych
 */

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.files.Paths;
import java.math.BigDecimal;

// ---------------------------------------------------------------------
// java.lang.ArithmeticException

BigDecimal doCalculation(BigDecimal input) {
    return BigDecimal.ONE.divide(input);
}

try {
    doCalculation(BigDecimal.ZERO);
} catch (ArithmeticException | IllegalArgumentException e) {
    System.err.println("Obliczenia si nie powiody: " + e);
}

// ---------------------------------------------------------------------

// java.io.FileNotFoundException

var path = Paths.get("nieprawidowa cieka");

try (var fileReader = new FileReader(path.toFile());
     var bufferedReader = new BufferedReader(fileReader)) {

    var firstLine = bufferedReader.readLine();
    System.err.println(firstLine);

} catch (IOException e) {
    System.err.println("Nie mona byo odczyta pierwszej linii z pliku " + path + ": " + e);
}