/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 9. Obsuga wartoci null za pomoc typw Optional
 *
 * Listing 9.8. Szukanie aktywnego administratora bez typw opcyjnych
 */

import java.util.List;
import java.util.Optional;

public record Permissions(List<String> permissions, Group group) {
  public boolean isEmpty() {
    return permissions.isEmpty();
  }
}

public record Group(Optional<User> admin) {
  // BRAK CIAA
}

public record User(boolean isActive) {
    // BRAK CIAA
}

User admin = new User(true);

Group group = new Group(Optional.of(admin));

Permissions permissions = new Permissions(List.of("A", "B", "C"),
                                          group);

boolean isActiveAdmin = false;

if (permissions != null && !permissions.isEmpty()) {

  if (permissions.group() != null) {
    var group = permissions.group();
    var maybeAdmin = group.admin();
  
    if (maybeAdmin.isPresent()) {
      var admin = maybeAdmin.orElseThrow();
      isActiveAdmin = admin.isActive();
    }
  }
}