/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 6. Przetwarzanie danych za pomoc strumieni
 *
 * Listing 6.14. Konkatenacja elementw String: porwnanie operacji reduce i collect
 */

import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

var strings = List.of("a", "b", "c", "d", "e");

// STRUMIE REDUCE

var reduced = strings.stream()
                     .reduce("", String::concat);


// STRUMIE COLLECT  NIESTANDARDOWY

var joiner =strings.stream()
                   .collect(Collector.of(() -> new StringJoiner(""),
                                         StringJoiner::add,
                                         StringJoiner::merge,
                                         StringJoiner::toString));

// STRUMIE COLLECT  PREDEFINIOWANY

var collectWithCollectors = strings.stream()
                                   .collect(Collectors.joining());
