/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 6. Przetwarzanie danych za pomoc strumieni
 *
 * Listing 6.8. Zagldanie do strumienia
 */

public record Shape(int corners) implements Comparable<Shape> {

    // METODY POMOCNICZE

    public boolean hasCorners() {
        return corners() > 0;
    }

    public List<Shape> twice() {
        return List.of(this, this);
    }

    @Override
    public int compareTo(Shape o) {
        return Integer.compare(corners(), o.corners());
    }

    // METODY WYTWRCZE

    public static Shape circle() {
        return new Shape(0);
    }

    public static Shape triangle() {
        return new Shape(3);
    }

    public static Shape square() {
        return new Shape(4);
    }
}

List<Shape> result =
    Stream.of(Shape.square(), Shape.triangle(), Shape.circle())
          .map(Shape::twice)
          .flatMap(List::stream)
          .peek(shape -> System.out.println("biecy: " + shape))
          .filter(shape -> shape.corners() < 4)
          .collect(Collectors.toList());
