/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 9. Obsuga wartoci null za pomoc typw Optional
 *
 * Listing 9.7. Operacje porednie, ktrych celem jest znalezienie aktywnego administratora
 */

import java.util.List;
import java.util.Optional;

public record Permissions(List<String> permissions, Group group) {
  public boolean isEmpty() {
    return permissions.isEmpty();
  }
}

public record Group(Optional<User> admin) {
  // BRAK CIAA
}

public record User(boolean isActive) {
    // BRAK CIAA
}

User admin = new User(true);

Group group = new Group(Optional.of(admin));

List<Permissions> permissions = List.of(new Permissions(List.of("A", "B", "C"),
                                                        group));

List<User> activeUsers =
  permissions.stream()
             .filter(Predicate.not(Permissions::isEmpty))
             .map(Permissions::group)
             .map(Group::admin)
             .flatMap(Optional::stream)
             .filter(User::isActive)
             .toList();
