/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 2. Funkcyjna Java
 * 
 * Listing 2.8. Referencje do metod i strumienie
 */

// Uproszczony typ Customer, aby kod si kompilowa
class Customer {
    private final String  name;
    private final boolean active;

    Customer(String name, boolean active) {
        this.name = name;
        this.active = active;
    }

    String getName() {
        return this.name;
    }

    boolean isActive() {
        return this.active;
    }
}


// LAMBDY

customers.stream()
         .filter(customer -> customer.isActive())
         .map(customer -> customer.getName())
         .map(name -> name.toUpperCase())
         .peek(name -> System.out.println(name))
         .toArray(count -> new String[count]);


// REFERENCJE DO METOD

customers.stream()
         .filter(Customer::isActive)
         .map(Customer::getName)
         .map(String::toUpperCase) 
         .peek(System.out::println)
         .toArray(String[]::new);
