package com.beliefdrivendesign.afatj.decorator_pattern.fp;

import com.beliefdrivendesign.afatj.decorator_pattern.shared.*;

public class Main {

    public static void main(String... args) {

        // SPARAMETRYZOWANE DEKOROWANIE
        CoffeeMaker decoratedCoffeeMaker = Barista.decorate(new BlackCoffeeMaker(),
                                                            coffeeMaker -> new AddMilkDecorator(coffeeMaker,
                                                                                                new MilkCarton()));

        System.out.println("[Sparametryzowane] Składniki do Café con Leche: " + decoratedCoffeeMaker.getIngredients());

        CoffeeMaker finalCoffeeMaker = Barista.decorate(decoratedCoffeeMaker,
                                                        AddSugarDecorator::new);


        // Dodawanie cukru

        CoffeeMaker lastDecoratedCoffeeMaker = new AddSugarDecorator(decoratedCoffeeMaker);

        System.out.println("[Sparametryzowane] Składniki po dodaniu cukru: " + lastDecoratedCoffeeMaker.getIngredients());


        // WIELE DEKORACJI

        CoffeeMaker multiDecoratedCoffeeMaker = Barista.decorate(new BlackCoffeeMaker(),
                                                                 coffeeMaker -> new AddMilkDecorator(coffeeMaker,
                                                                                                     new MilkCarton()),
                                                                 AddSugarDecorator::new);

                                                                 System.out.println("[Liczne] Składniki: " + lastDecoratedCoffeeMaker.getIngredients());


        // TYP POMOCNICZY DECORATIONS

        var milkCarton = new MilkCarton();

        CoffeeMaker maker = Barista.decorate(new BlackCoffeeMaker(),
                                             Decorations.addMilk(milkCarton),
                                             Decorations.addSugar());

        System.out.println("[Pomocnicze] Składniki: " + lastDecoratedCoffeeMaker.getIngredients());
    }
}
