package com.beliefdrivendesign.afatj.builder_pattern.fp;

public class Main {

    public static void main(String... args) {

        // LENIWY BUDOWNICZY

        var builder = User.builder()
                          .name(() -> "Ben Weidig")
                          .email("ben@example.com");

        var user = builder.addPermission("tworzenie")
                          .addPermission("edycja")
                          .build();

        System.out.println(user);


        // Z BUDOWNICZYM

        var user2 = UserWith.builder()
                            .with(with -> {
                                with.email = "ben@example.com";
                                with.name = "Ben Weidig";
                            })
                            .withPermissions(permissions -> {
                                permissions.add("tworzenie");
                                permissions.add("przegldanie");
                            })
                            .build();

        System.out.println(user2);
    }
}
