/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 11. Ewaluacja leniwa
 */

import java.util.Collections;
import java.util.List;


record Role(String name) {}

record User(List<Role> roles) {}

class DAO {
    public List<Role> loadAllAvailableRoles() {
        return List.of(new Role("admin"),
                       new Role("go"));
    }
}

User updateUser(User user,
                DAO dao) {
    return new User(dao.loadAllAvailableRoles());
}


var dao = new DAO();

// SPOSB UYCIA

var user = new User(Collections.emptyList());

var updatedUser = updateUser(user, dao);
