/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 10. Obsuga wyjtkw funkcyjnych
 *
 * Listing 10.1. Wyodrbnianie kodu rzucania wyjtkw do bezpiecznej metody
 */

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import java.util.Objects;

public class SafeMethodExtraction {

  static String safeReadString(Path path) {
      try {
        return Files.readString(path);
      } catch (IOException e) {
        return null;
      }
    }

    public static void main(String... args) {
        var result = Stream.of(Paths.get("../jshell/try-catch.java"), Paths.get("../jshell/files-readstring.java"))
                           .map(SafeMethodExtraction::safeReadString)
                           .filter(Objects::nonNull)
                           .toList();

        System.out.println("Znaleziono: " + result.size());
    }
}
