/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 8. Rwnolege przetwarzanie danych za pomoc strumieni
 *
 * Listing 8.5. Statystyka liczb losowych
 */

import java.util.IntSummaryStatistics;
import java.util.Random;
import java.util.function.IntUnaryOperator;

var elementsCount = 100_000_000;

IntUnaryOperator multiplyByTwo = in -> in * 2; 

var rnd = new Random(); 

// PTLA FOR 
var loopStats = new IntSummaryStatistics();

for(int idx = 0; idx < elementsCount; idx++) {
    var value = rnd.nextInt();
    var subResult = multiplyByTwo.applyAsInt(value);
    var finalResult = multiplyByTwo.applyAsInt(subResult);
    loopStats.accept(finalResult);
}

System.out.println(loopStats);
