/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 2. Funkcyjna Java
 */

// Interfejs funkcyjny rwnowany z java.util.Predicate<T>
interface LikePredicate<T> {

    boolean test(T value);
}


LikePredicate<String> isNull = $ -> $ == null;

// Przypisanie isNull do interfejsu funkcyjnego z identyczn metod SAM si nie skompiluje
Predicate<String> wontCompile = isNull;

// Error:
// incompatible types: LikePredicate<java.lang.String> cannot be converted
// to java.util.function.Predicate<java.lang.String>
// Predicate<String> wontCompile = isNull;
//                                 ^----^
