package test;

import com.apress.framework.core.Application;
import com.apress.framework.objecttypes.Controller;
import com.apress.framework.objecttypes.EVT;
import com.apress.framework.objecttypes.Event;
import com.apress.framework.objecttypes.EventListener;

public class Player implements Controller, EventListener
{
    private int reactsTo, responseEvent;
    private TestView testView;
    
    public Player(int reactsTo, int sendsOut, String saying)
    {
        this.reactsTo = reactsTo;
        this.responseEvent = sendsOut;
        TestModel model = new TestModel(saying);
        this.testView = new TestView(this,model);
    }
    
    public boolean handleEvent(Event event)
    {
        if ( event.getContext() == EVT.CONTEXT.TEST )
        {
            if ( event.getType() == reactsTo)
            {
                // Wyświetl widok dla tego kontrolera
                Application.showView(testView);
                // Dodaj do kolejki odpowiednie zdarzenie odpowiedzi
                Event evt = new Event(EVT.CONTEXT.TEST, responseEvent, this);
                Application.getMainEventController().queueEvent(evt);
                
                return true;
            }
        }
        return false;
    }
}
