/*
 * Decompiled with CFR 0.152.
 */
package impl.javame.com.twitterapime.parser;

import com.twitterapime.parser.Handler;
import com.twitterapime.parser.Parser;
import com.twitterapime.parser.ParserException;
import com.twitterapime.parser.XMLHandler;
import impl.javame.com.twitterapime.parser.KXML2Attributes;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public final class KXML2Parser
extends Parser {
    public void parse(InputStream stream, Handler handler) throws IOException, ParserException {
        if (stream == null) {
            throw new NullPointerException("stream must not be null.");
        }
        if (handler == null) {
            throw new NullPointerException("handler must not be null.");
        }
        if (!(handler instanceof XMLHandler)) {
            throw new ClassCastException("handler must be an instace of XMLHandler.");
        }
        KXmlParser parser = new KXmlParser();
        XMLHandler xmlHandler = (XMLHandler)handler;
        KXML2Attributes attrs = new KXML2Attributes();
        try {
            parser.setInput(new InputStreamReader(stream, "UTF-8"));
            while (true) {
                int etype;
                if ((etype = parser.next()) == 0) {
                    xmlHandler.startDocument();
                    continue;
                }
                if (etype == 2) {
                    attrs.loadAttributes(parser);
                    xmlHandler.startElement(parser.getNamespace(), parser.getName(), this.getQName(parser), attrs);
                    continue;
                }
                if (etype == 3) {
                    xmlHandler.endElement(parser.getNamespace(), parser.getName(), this.getQName(parser));
                    continue;
                }
                if (etype == 4) {
                    xmlHandler.text(parser.getText().trim());
                    continue;
                }
                if (etype == 1) break;
            }
            xmlHandler.endDocument();
        }
        catch (XmlPullParserException e) {
            throw new ParserException(e.getMessage());
        }
    }

    private String getQName(KXmlParser p) {
        String qName = p.getPrefix();
        if (qName != null && !qName.equals("")) {
            qName = qName + ":" + p.getName();
        }
        return qName;
    }
}

