/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.xauth;

import com.twitterapime.util.StringUtil;

public final class Token {
    private String token;
    private String secret;

    public static Token parse(String accessTokenString) {
        String[] tokens = StringUtil.split(accessTokenString, '&');
        String access = StringUtil.split(tokens[0], '=')[1];
        String secret = StringUtil.split(tokens[1], '=')[1];
        return new Token(access, secret);
    }

    public Token(String token, String secret) {
        if (token == null || (token = token.trim()).length() == 0) {
            throw new IllegalArgumentException("Token must not be empty/null");
        }
        if (secret == null || (secret = secret.trim()).length() == 0) {
            throw new IllegalArgumentException("Secret must not be empty/null");
        }
        this.token = token;
        this.secret = secret;
    }

    public String getToken() {
        return this.token;
    }

    public String getSecret() {
        return this.secret;
    }

    public String toString() {
        return "oauth_token: " + this.token + " oauth_token_secret: " + this.secret;
    }
}

