/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.search;

import com.twitterapime.io.HttpRequest;
import com.twitterapime.io.HttpResponse;
import com.twitterapime.io.HttpResponseCodeInterpreter;
import com.twitterapime.parser.Parser;
import com.twitterapime.parser.ParserException;
import com.twitterapime.parser.ParserFactory;
import com.twitterapime.rest.RateLimitStatus;
import com.twitterapime.rest.handler.RateLimitStatusHandler;
import com.twitterapime.search.InvalidQueryException;
import com.twitterapime.search.LimitExceededException;
import com.twitterapime.search.Query;
import com.twitterapime.search.SearchDeviceListener;
import com.twitterapime.search.Tweet;
import com.twitterapime.search.handler.SearchResultHandler;
import java.io.IOException;
import java.util.Hashtable;

public final class SearchDevice {
    private static final Hashtable SERVICES_URL = new Hashtable(2);
    private static final String TWITTER_QUERY_STRING_PREFIX = "q=";
    private static SearchDevice device;
    private static long lastCallTime;
    private static int apiCallsCount;
    public static final String TWITTER_API_URL_SERVICE_SEARCH = "TWITTER_API_URL_SERVICE_SEARCH";
    public static final String TWITTER_API_URL_SERVICE_ACCOUNT_RATE_LIMIT_STATUS = "TWITTER_API_URL_SERVICE_ACCOUNT_RATE_LIMIT_STATUS";

    private String getURL(String serviceKey) {
        return (String)SERVICES_URL.get(serviceKey);
    }

    public void setServiceURL(String serviceKey, String url) {
        SERVICES_URL.put(serviceKey, url);
    }

    public static synchronized SearchDevice getInstance() {
        if (device == null) {
            device = new SearchDevice();
        }
        return device;
    }

    private SearchDevice() {
    }

    public Tweet[] searchTweets(Query query) throws IOException, LimitExceededException {
        if (query == null) {
            throw new IllegalArgumentException("Query must not be null.");
        }
        return this.searchTweets(query, null);
    }

    public Tweet[] searchTweets(String queryString) throws IOException, LimitExceededException {
        if (queryString == null || (queryString = queryString.trim()).length() == 0) {
            throw new IllegalArgumentException("QueryString must not be null/empty.");
        }
        return this.searchTweets(new Query(queryString), null);
    }

    public void startSearchTweets(Query query, SearchDeviceListener listener) {
        if (query == null) {
            throw new IllegalArgumentException("Query must not be null.");
        }
        this.startSearchTweets(query.toString(), listener);
    }

    public void startSearchTweets(final String queryString, final SearchDeviceListener listener) {
        if (queryString == null || queryString.length() == 0) {
            throw new IllegalArgumentException("QueryString must not be null/empty.");
        }
        Runnable r = new Runnable(){

            public void run() {
                block3: {
                    try {
                        SearchDevice.this.searchTweets(new Query(queryString), listener);
                        if (listener != null) {
                            listener.searchCompleted();
                        }
                    }
                    catch (Exception e) {
                        if (listener == null) break block3;
                        listener.searchFailed(e);
                    }
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    public RateLimitStatus getRateLimitStatus() throws IOException, LimitExceededException {
        HttpRequest req = new HttpRequest(this.getURL(TWITTER_API_URL_SERVICE_ACCOUNT_RATE_LIMIT_STATUS));
        try {
            HttpResponse resp = req.send();
            HttpResponseCodeInterpreter.perform(resp);
            Parser parser = ParserFactory.getDefaultParser();
            RateLimitStatusHandler handler = new RateLimitStatusHandler();
            parser.parse(resp.getStream(), handler);
            RateLimitStatus rateLimitStatus = handler.getParsedRateLimitStatus();
            return rateLimitStatus;
        }
        catch (ParserException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            req.close();
        }
    }

    public int getAPICallsCount() {
        return apiCallsCount;
    }

    public long getLastAPICallTime() {
        return lastCallTime;
    }

    private Tweet[] searchTweets(Query query, SearchDeviceListener l) throws IOException, LimitExceededException {
        this.updateAPIInfo();
        HttpRequest req = this.createRequest(query.toString());
        try {
            HttpResponse resp = req.send();
            if (resp.getCode() == 403) {
                throw new InvalidQueryException(HttpResponseCodeInterpreter.getErrorMessage(resp));
            }
            HttpResponseCodeInterpreter.perform(resp);
            Parser parser = ParserFactory.getDefaultParser();
            SearchResultHandler handler = new SearchResultHandler();
            handler.setSearchDeviceListener(l);
            parser.parse(resp.getStream(), handler);
            Tweet[] tweetArray = handler.getParsedTweets();
            return tweetArray;
        }
        catch (ParserException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            req.close();
        }
    }

    private HttpRequest createRequest(String queryStr) {
        if (queryStr == null || (queryStr = queryStr.trim()).length() == 0) {
            throw new IllegalArgumentException("Query String must not be empty/null.");
        }
        if (!queryStr.startsWith("?")) {
            queryStr = !queryStr.startsWith(TWITTER_QUERY_STRING_PREFIX) ? "?q=&" + queryStr : '?' + queryStr;
        }
        return new HttpRequest(this.getURL(TWITTER_API_URL_SERVICE_SEARCH) + queryStr);
    }

    private void updateAPIInfo() {
        lastCallTime = System.currentTimeMillis();
        ++apiCallsCount;
    }

    static {
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_SEARCH, "http://search.twitter.com/search.atom");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_ACCOUNT_RATE_LIMIT_STATUS, "http://api.twitter.com/1/account/rate_limit_status.xml");
    }
}

