/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.rest;

import com.twitterapime.model.DefaultEntity;
import com.twitterapime.search.Tweet;
import com.twitterapime.util.StringUtil;
import java.util.Hashtable;

public final class UserAccount
extends DefaultEntity {
    public UserAccount() {
    }

    public UserAccount(Hashtable data) {
        super(data);
    }

    public UserAccount(String userNameOrID) {
        if (StringUtil.isEmpty(userNameOrID)) {
            throw new IllegalArgumentException("Username/ID must not be empty/null.");
        }
        Hashtable<String, String> data = new Hashtable<String, String>();
        try {
            Long.parseLong(userNameOrID);
            data.put("USERACCOUNT_ID", userNameOrID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        data.put("USERACCOUNT_USER_NAME", userNameOrID);
        this.setData(data);
    }

    public Tweet getLastTweet() {
        return (Tweet)this.getObject("USERACCOUNT_LAST_TWEET");
    }

    String getUserNameOrID() {
        String id = this.getString("USERACCOUNT_ID");
        if (StringUtil.isEmpty(id)) {
            id = this.getString("USERACCOUNT_USER_NAME");
        }
        return id;
    }

    String[] getUserNameOrIDParamValue() {
        String us;
        String[] paramValue = new String[2];
        String id = this.getString("USERACCOUNT_ID");
        if (!StringUtil.isEmpty(id)) {
            try {
                Long.parseLong(id);
                paramValue[0] = "user_id";
                paramValue[1] = id;
                return paramValue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!StringUtil.isEmpty(us = this.getString("USERACCOUNT_USER_NAME"))) {
            paramValue[0] = "screen_name";
            paramValue[1] = us;
        }
        return paramValue;
    }

    void validateUserNameOrID() {
        if (StringUtil.isEmpty(this.getUserNameOrID())) {
            throw new IllegalArgumentException("Username/ID must no be empty/null");
        }
    }
}

