/*
 * Decompiled with CFR 0.152.
 */
package com.apress.framework.common;

import com.apress.framework.common.EventController;
import com.apress.framework.objecttypes.Manager;
import java.util.Enumeration;
import java.util.Vector;

public class EventControllerManager
implements Manager {
    public Vector controllers = new Vector(10, 10);

    public boolean assign(Object object) {
        if (object instanceof EventController) {
            if (!this.controllers.contains(object)) {
                this.controllers.addElement(object);
            }
            return true;
        }
        return false;
    }

    public void unassign(Object object) {
        this.controllers.removeElement(object);
    }

    public boolean isManaging(Object object) {
        return this.controllers.indexOf(object) > -1;
    }

    public void processNextEvent() {
        if (this.controllers.size() > 0) {
            EventController controller = (EventController)this.controllers.firstElement();
            this.controllers.removeElement(controller);
            controller.processNextEvent();
            this.controllers.addElement(controller);
        }
    }

    public boolean hasMoreEvents() {
        return this.currentEventCount() > 0;
    }

    public int currentEventCount() {
        Enumeration controllerEnum = this.controllers.elements();
        EventController temp = null;
        int count = 0;
        while (controllerEnum.hasMoreElements()) {
            temp = (EventController)controllerEnum.nextElement();
            if (!temp.hasMoreEvents()) continue;
            count += temp.currentEventCount();
        }
        return count;
    }
}

