/*
 * Decompiled with CFR 0.152.
 */
package com.apress.framework.common;

import com.apress.framework.objecttypes.Controller;
import com.apress.framework.objecttypes.Event;
import com.apress.framework.objecttypes.EventListener;
import java.util.Vector;

public class EventController
implements Controller {
    protected Vector listeners = new Vector(10, 10);
    protected Vector events = new Vector(10, 10);

    public void registerListener(EventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public void unregisterListener(EventListener listener) {
        this.listeners.removeElement(listener);
    }

    public void queueEvent(Event event) {
        this.events.addElement(event);
    }

    public void processNextEvent() {
        if (this.events.size() > 0) {
            Event event = (Event)this.events.firstElement();
            this.events.removeElement(event);
            int listenerCount = this.listeners.size();
            for (int currentIndex = 0; currentIndex < listenerCount; ++currentIndex) {
                EventListener temp = (EventListener)this.listeners.elementAt(currentIndex);
                temp.handleEvent(event);
            }
        }
    }

    public int currentEventCount() {
        return this.events.size();
    }

    public boolean hasMoreEvents() {
        return this.events.size() > 0;
    }
}

