/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.model;

import com.twitterapime.model.Entity;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class DefaultEntity
implements Entity {
    protected Hashtable data;

    public DefaultEntity() {
        this.setData((Hashtable)null);
    }

    public DefaultEntity(Hashtable data) {
        this.setData(data);
    }

    public final void setData(Hashtable data) {
        if (data == null) {
            data = new Hashtable();
        }
        this.data = data;
    }

    public final void setData(DefaultEntity e) {
        this.setData(e.data);
    }

    public final Object[] getArray(String attr) {
        return (Object[])this.getValue(attr, new Object[]{""}.getClass());
    }

    public final Date getDate(String attr) {
        return (Date)this.getValue(attr, new Date().getClass());
    }

    public final int getInt(String attr) {
        Integer v = (Integer)this.getValue(attr, new Integer(0).getClass());
        return v != null ? v : Integer.MIN_VALUE;
    }

    public final long getLong(String attr) {
        Object v = this.getObject(attr);
        if (v instanceof Date) {
            return ((Date)v).getTime();
        }
        v = (Long)this.getValue(attr, new Long(0L).getClass());
        return v != null ? (Long)v : Long.MIN_VALUE;
    }

    public final Object getObject(String attr) {
        return this.data.get(attr);
    }

    public final String getString(String attr) {
        Object v = this.data.get(attr);
        return v != null ? v.toString() : null;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof DefaultEntity)) {
            return false;
        }
        return this.areEquals(this.data, ((DefaultEntity)o).data);
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public final String toString() {
        StringBuffer s = new StringBuffer();
        Enumeration keys = this.data.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            s.append(key + ": " + this.data.get(key) + "\n");
        }
        return s.toString();
    }

    public final int size() {
        return this.data.size();
    }

    private boolean areEquals(Hashtable h1, Hashtable h2) {
        if (h1.size() != h2.size()) {
            return false;
        }
        Enumeration keys = h1.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object val1 = h1.get(key);
            Object val2 = h2.get(key);
            if (val1 instanceof Object[] && val2 instanceof Object[]) {
                Object[] aval1 = (Object[])val1;
                Object[] aval2 = (Object[])val2;
                if (aval1.length != aval2.length) {
                    return false;
                }
                for (int i = 0; i < aval1.length; ++i) {
                    if (aval1[i].equals(aval2[i])) continue;
                    return false;
                }
                continue;
            }
            if (h1.get(key).equals(h2.get(key))) continue;
            return false;
        }
        return true;
    }

    private Object getValue(String attr, Class type) {
        Object v = this.data.get(attr);
        if (v != null && !type.isInstance(v)) {
            throw new ClassCastException("Invalid type value: " + v.getClass().getName());
        }
        return v;
    }
}

