/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.rest.handler;

import com.twitterapime.parser.Attributes;
import com.twitterapime.parser.DefaultXMLHandler;
import com.twitterapime.parser.ParserException;
import com.twitterapime.rest.GeoLocation;
import com.twitterapime.rest.UserAccount;
import com.twitterapime.rest.handler.GeoLocationHandler;
import com.twitterapime.rest.handler.TweetHandler;
import com.twitterapime.rest.handler.UserAccountHandler;
import com.twitterapime.search.SearchDeviceListener;
import com.twitterapime.search.Tweet;
import java.util.Hashtable;
import java.util.Vector;

public final class TimelineHandler
extends DefaultXMLHandler {
    private UserAccountHandler uaHandler = new UserAccountHandler();
    private TweetHandler tHandler = new TweetHandler();
    private GeoLocationHandler lHandler = new GeoLocationHandler();
    private Vector tweetList = new Vector(10);
    private Hashtable userValues;
    private Hashtable tweetValues;
    private Hashtable reuserValues;
    private Hashtable retweetValues;
    private Hashtable locationValues;
    private SearchDeviceListener listener;

    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws ParserException {
        super.startElement(namespaceURI, localName, qName, attrs);
        if (localName.toLowerCase().equals("status")) {
            this.tweetValues = new Hashtable(5);
            this.userValues = new Hashtable(25);
            this.retweetValues = new Hashtable(5);
            this.reuserValues = new Hashtable(25);
            this.locationValues = new Hashtable(10);
            this.tweetValues.put("TWEET_USER_ACCOUNT", new UserAccount(this.userValues));
            this.tweetList.addElement(new Tweet(this.tweetValues));
        }
    }

    public void text(String text) throws ParserException {
        text = text.trim();
        if (this.xmlPath.startsWith("/statuses/status/retweeted_status/user/")) {
            this.uaHandler.populate(this.reuserValues, this.xmlPath, text);
        } else if (this.xmlPath.startsWith("/statuses/status/retweeted_status/")) {
            this.tHandler.populate(this.retweetValues, this.xmlPath, text);
        } else if (this.xmlPath.startsWith("/statuses/status/user/")) {
            this.uaHandler.populate(this.userValues, this.xmlPath, text);
        } else if (this.xmlPath.startsWith("/statuses/status/geo/")) {
            this.lHandler.populate(this.locationValues, this.xmlPath, text);
        } else if (this.xmlPath.startsWith("/statuses/status/place/")) {
            this.lHandler.populate(this.locationValues, this.xmlPath, text);
        } else if (this.xmlPath.startsWith("/statuses/status/")) {
            this.tHandler.populate(this.tweetValues, this.xmlPath, text);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws ParserException {
        super.endElement(namespaceURI, localName, qName);
        if (localName.toLowerCase().equals("status")) {
            if (this.retweetValues.size() > 0) {
                this.retweetValues.put("TWEET_USER_ACCOUNT", new UserAccount(this.reuserValues));
                this.tweetValues.put("TWEET_REPOSTED_TWEET", this.retweetValues);
            }
            if (this.locationValues.size() > 0) {
                this.tweetValues.put("TWEET_LOCATION", new GeoLocation(this.locationValues));
            }
            this.fireTweetParsed((Tweet)this.tweetList.lastElement());
        }
    }

    public Tweet[] getParsedTweets() {
        Object[] ts = new Tweet[this.tweetList.size()];
        this.tweetList.copyInto(ts);
        return ts;
    }

    public void setSearchDeviceListener(SearchDeviceListener listener) {
        this.listener = listener;
    }

    private void fireTweetParsed(Tweet tweet) {
        if (this.listener != null) {
            this.listener.tweetFound(tweet);
        }
    }
}

