/*
 * Decompiled with CFR 0.152.
 */
package app.module.persistence.models;

import app.module.persistence.classes.RecordReader;
import app.module.persistence.models.ByteDeserializer;

public class ByteRecordReader
implements RecordReader {
    byte[] recordData = null;
    int currentOffset = 0;
    ByteDeserializer bds = new ByteDeserializer();

    public ByteRecordReader(byte[] data) {
        this.recordData = data;
    }

    public int readInt() {
        int result = this.bds.deserializeInt(this.recordData, this.currentOffset);
        this.currentOffset += 4;
        return result;
    }

    public long readLong() {
        long result = this.bds.deserializeLong(this.recordData, this.currentOffset);
        this.currentOffset += 8;
        return result;
    }

    public String readString() {
        int strSize = this.readInt();
        String result = this.bds.deserializeString(this.recordData, this.currentOffset, strSize);
        this.currentOffset += strSize;
        return result;
    }

    public boolean readBoolean() {
        boolean result = this.bds.deserializeBoolean(this.recordData, this.currentOffset);
        ++this.currentOffset;
        return result;
    }

    public byte readByte() {
        byte result = this.recordData[this.currentOffset];
        ++this.currentOffset;
        return result;
    }
}

