/*
 * Decompiled with CFR 0.152.
 */
package app.module.network.models;

import app.models.Timeline;
import app.models.Tweet;
import app.models.TweetFilter;
import app.models.TwitterServer;
import app.models.TwitterUser;
import app.models.UserCredentials;
import app.module.network.classes.TimelineHome;
import app.module.network.classes.TimelineUserTweets;
import com.apress.framework.common.EventController;
import com.apress.framework.objecttypes.Event;
import com.apress.framework.objecttypes.EventListener;
import com.twitterapime.rest.Credential;
import com.twitterapime.rest.TweetER;
import com.twitterapime.rest.UserAccount;
import com.twitterapime.rest.UserAccountManager;
import com.twitterapime.xauth.Token;

public class ServerImplementation
implements TwitterServer,
EventListener {
    protected String consumerKey;
    protected String consumerSecret;
    protected EventController eventController;
    protected UserAccountManager accountManager = null;

    protected ServerImplementation() {
    }

    public ServerImplementation(String consumerKey, String consumerSecret, EventController controller) {
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.eventController = controller;
        controller.registerListener(this);
    }

    public boolean handleEvent(Event event) {
        if (event.getType() == 30001) {
            this.login((UserCredentials)event.getPayload());
            return true;
        }
        return false;
    }

    public EventController getEventController() {
        return this.eventController;
    }

    protected boolean loginUsingUnPw(String username, String password) {
        Credential c = new Credential(username, password, this.consumerKey, this.consumerSecret);
        UserAccountManager m = UserAccountManager.getInstance(c);
        try {
            if (m.verifyCredential()) {
                this.accountManager = m;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected boolean loginUsingTokens(String token, String tokenSecret) {
        Token authToken = new Token(token, tokenSecret);
        Credential c = new Credential("ignorowaneWTymKontek\u015bcie", this.consumerKey, this.consumerSecret, authToken);
        UserAccountManager m = UserAccountManager.getInstance(c);
        try {
            if (m.verifyCredential()) {
                this.accountManager = m;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean login(UserCredentials credentials) {
        boolean success = false;
        if (credentials.getUsername() != null && credentials.getPassword() != null) {
            success = this.loginUsingUnPw(credentials.getUsername(), credentials.getPassword());
        }
        if (!success && credentials.getAccessToken() != null && credentials.getAccessTokenSecret() != null) {
            success = this.loginUsingTokens(credentials.getAccessToken(), credentials.getAccessTokenSecret());
        }
        if (success) {
            Event evt = new Event(3, 30003, credentials);
            this.eventController.queueEvent(evt);
        } else {
            Event evt = new Event(3, 30002, credentials);
            this.eventController.queueEvent(evt);
        }
        return success;
    }

    public TwitterUser getMyProfile() {
        try {
            UserAccount account = this.accountManager.getUserAccount();
            if (account == null) {
                return null;
            }
            return new TwitterUser(account.getString("USERACCOUNT_NAME"), account.getString("USERACCOUNT_USER_NAME"), account.getString("USERACCOUNT_DESCRIPTION"), account.getString("USERACCOUNT_URL"), account.getString("USERACCOUNT_LOCATION"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public TwitterUser getProfileFor(String userid) {
        try {
            UserAccount account = this.accountManager.getUserAccount(new UserAccount(userid));
            if (account == null) {
                return null;
            }
            return new TwitterUser(account.getString("USERACCOUNT_NAME"), account.getString("USERACCOUNT_USER_NAME"), account.getString("USERACCOUNT_DESCRIPTION"), account.getString("USERACCOUNT_URL"), account.getString("USERACCOUNT_LOCATION"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Timeline getTimelineForFilter(TweetFilter filter) {
        if (filter == null || filter.getUserID() == null) {
            return new TimelineHome(this.accountManager);
        }
        return new TimelineUserTweets(this.accountManager, filter);
    }

    public boolean postTweet(Tweet tweet) {
        com.twitterapime.search.Tweet libTweet = new com.twitterapime.search.Tweet(tweet.getBody());
        if (this.accountManager != null) {
            TweetER tweeter = TweetER.getInstance(this.accountManager);
            try {
                tweeter.post(libTweet);
            }
            catch (Exception ex) {
                return false;
            }
            return true;
        }
        return false;
    }
}

