/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.rest.handler;

import com.twitterapime.parser.DefaultXMLHandler;
import com.twitterapime.parser.ParserException;
import com.twitterapime.rest.GeoLocation;
import com.twitterapime.rest.UserAccount;
import com.twitterapime.rest.handler.GeoLocationHandler;
import com.twitterapime.rest.handler.TweetHandler;
import com.twitterapime.rest.handler.UserAccountHandler;
import com.twitterapime.search.Tweet;
import java.util.Hashtable;

public final class StatusHandler
extends DefaultXMLHandler {
    private UserAccountHandler uaHandler = new UserAccountHandler();
    private TweetHandler tHandler = new TweetHandler();
    private GeoLocationHandler lHandler = new GeoLocationHandler();
    private Hashtable userAccountValues = new Hashtable(25);
    private Hashtable reuserAccountValues = new Hashtable(25);
    private Hashtable tweetValues = new Hashtable(10);
    private Hashtable retweetValues = new Hashtable(10);
    private Hashtable locationValues = new Hashtable(10);

    public void text(String text) throws ParserException {
        text = text.trim();
        if (this.xmlPath.startsWith("/status/retweeted_status/user/")) {
            this.uaHandler.populate(this.reuserAccountValues, this.xmlPath, text);
        } else if (this.xmlPath.startsWith("/status/retweeted_status/")) {
            this.tHandler.populate(this.retweetValues, this.xmlPath, text);
        } else if (this.xmlPath.startsWith("/status/user/")) {
            this.uaHandler.populate(this.userAccountValues, this.xmlPath, text);
        } else if (this.xmlPath.startsWith("/status/geo/")) {
            this.lHandler.populate(this.locationValues, this.xmlPath, text);
        } else if (this.xmlPath.startsWith("/status/place/")) {
            this.lHandler.populate(this.locationValues, this.xmlPath, text);
        } else if (this.xmlPath.startsWith("/status/")) {
            this.tHandler.populate(this.tweetValues, this.xmlPath, text);
        }
    }

    public void endDocument() throws ParserException {
        this.tweetValues.put("TWEET_USER_ACCOUNT", new UserAccount(this.userAccountValues));
        if (this.retweetValues.size() > 0) {
            this.retweetValues.put("TWEET_USER_ACCOUNT", new UserAccount(this.reuserAccountValues));
            this.tweetValues.put("TWEET_REPOSTED_TWEET", new Tweet(this.retweetValues));
        }
        if (this.locationValues.size() > 0) {
            this.tweetValues.put("TWEET_LOCATION", new GeoLocation(this.locationValues));
        }
    }

    public Tweet getParsedTweet() {
        return new Tweet(this.tweetValues);
    }

    public void loadParsedTweet(Tweet tweet) {
        tweet.setData(this.tweetValues);
    }
}

