/*
 * Decompiled with CFR 0.152.
 */
package app.module.ui.models;

import app.module.ui.models.ClipRect;
import app.module.ui.models.Container;
import app.module.ui.models.Widget;
import com.apress.framework.objecttypes.View;

public abstract class BaseWidget
implements Widget {
    protected int contentWidth;
    protected int contentHeight;
    protected int x;
    protected int y;
    protected ClipRect clipRect = new ClipRect(0, 0, 0, 0);
    protected Container parent;
    protected boolean isFocused = false;
    protected Object widgetData = null;

    public void setContentHeight(int contentHeight) {
        this.contentHeight = contentHeight;
    }

    public int getContentWidth() {
        return this.contentWidth;
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public void setContentWidth(int contentWidth) {
        this.contentWidth = contentWidth;
    }

    public ClipRect getClipRect() {
        this.clipRect.setMaxX(this.getAbsoluteX() + this.getTotalWidth());
        this.clipRect.setMaxY(this.getAbsoluteY() + this.getTotalHeight());
        this.clipRect.setMinX(this.getAbsoluteX());
        this.clipRect.setMinY(this.getAbsoluteY());
        return this.clipRect;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getTotalWidth() {
        if (this.contentWidth > 0) {
            return this.contentWidth;
        }
        return this.getPreferredContentWidth();
    }

    public int getTotalHeight() {
        if (this.contentHeight > 0) {
            return this.contentHeight;
        }
        return this.getPreferredContentHeight();
    }

    public void setParent(Container widget) {
        this.parent = widget;
    }

    public Container getParent() {
        return this.parent;
    }

    public int getAbsoluteX() {
        return this.parent.getAbsoluteX() - this.parent.getXScroll() + this.getX();
    }

    public int getAbsoluteY() {
        return this.parent.getAbsoluteY() - this.parent.getYScroll() + this.getY();
    }

    public void requestRepaint() {
        View v = this.getParentView();
        if (v != null) {
            this.getParentView().paintWidget(this);
        }
    }

    public View getParentView() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getParentView();
    }

    public boolean handleKeyPressed(int key) {
        return false;
    }

    public boolean handleKeyReleased(int key) {
        return false;
    }

    public boolean handlePointerPressed(int x, int y) {
        return false;
    }

    public boolean handlePointerDragged(int x, int y) {
        return false;
    }

    public boolean handlePointerReleased(int x, int y) {
        if (this.isFocusable() && !this.isFocused()) {
            if (this.getParent() != null) {
                this.getParent().focusWidget(this);
            }
            return true;
        }
        return false;
    }

    public boolean onFocus() {
        this.isFocused = true;
        return true;
    }

    public boolean onLostFocus() {
        this.isFocused = false;
        return false;
    }

    public boolean isFocusable() {
        return false;
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public Object getData() {
        return this.widgetData;
    }

    public void setData(Object object) {
        this.widgetData = object;
    }
}

