/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.search;

import com.twitterapime.search.InvalidQueryException;
import java.io.UnsupportedEncodingException;

public final class Query {
    private String query;

    Query(String query) {
        if (query == null) {
            throw new IllegalArgumentException("Query must not be null.");
        }
        try {
            this.query = new String(query.getBytes(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidQueryException("Invalid UTF-8 string: " + query);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof Query)) {
            return false;
        }
        return this.query.equals(((Query)o).query);
    }

    public int hashCode() {
        return this.query.hashCode();
    }

    public String toString() {
        return this.query;
    }
}

