/*
 * Decompiled with CFR 0.152.
 */
package com.apress.framework.core;

import com.apress.framework.common.EventControllerManager;
import java.util.Hashtable;

public class EventManagerThreads {
    protected static Hashtable threads = new Hashtable();

    protected EventManagerThreads() {
    }

    public static void start(EventControllerManager manager, long sleepTime) {
        EventManagerThreads.stop(manager);
        ManagerThread thread = null;
        thread = new ManagerThread(manager, sleepTime);
        Thread t = new Thread(thread);
        t.start();
        threads.put(manager, thread);
    }

    public static void stop(EventControllerManager manager) {
        ManagerThread thread = (ManagerThread)threads.get(manager);
        if (thread != null) {
            thread.stop();
        }
    }

    public static class ManagerThread
    implements Runnable {
        EventControllerManager manager = null;
        long sleepTime = 0L;
        boolean run = true;

        public ManagerThread(EventControllerManager manager, long sleepTime) {
            this.manager = manager;
            this.sleepTime = sleepTime;
        }

        public void run() {
            while (this.run) {
                for (int evtCount = this.manager.currentEventCount(); evtCount > 0; --evtCount) {
                    this.manager.processNextEvent();
                }
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }

        public void stop() {
            this.run = false;
        }
    }
}

