/*
 * Decompiled with CFR 0.152.
 */
package app.module.ui.classes;

import app.module.ui.helpers.ClipHelper;
import app.module.ui.helpers.KeyHelper;
import app.module.ui.models.BaseWidget;
import app.module.ui.models.CallbackHandler;
import app.module.ui.models.UITheme;
import com.apress.framework.objecttypes.Event;
import javax.microedition.lcdui.Graphics;

public class SimpleTextButton
extends BaseWidget {
    protected String text;
    protected CallbackHandler handler;
    protected UITheme theme;
    protected int PADDING = 5;

    public SimpleTextButton(String text, CallbackHandler handler, UITheme theme) {
        this.text = text;
        this.handler = handler;
        this.theme = theme;
    }

    public void paint(Graphics g) {
        ClipHelper.setClipOn(this, g);
        int bgColor = this.theme.getNotSelectedBgColor();
        int fgColor = this.theme.getNotSelectedFgColor();
        if (this.isFocused()) {
            bgColor = this.theme.getSelectedBgColor();
            fgColor = this.theme.getSelectedFgColor();
        }
        g.setColor(bgColor);
        g.fillRoundRect(this.getAbsoluteX(), this.getAbsoluteY(), this.getTotalWidth(), this.getTotalHeight(), 15, 15);
        g.setColor(fgColor);
        g.setFont(this.theme.getSelectedFont());
        int sizeInPixels = this.theme.getSelectedFont().stringWidth(this.text);
        int posX = (this.getTotalWidth() - sizeInPixels) / 2;
        g.drawString(this.text, this.getAbsoluteX() + posX, this.getAbsoluteY() + this.PADDING, 20);
        ClipHelper.resetClip(g);
    }

    public boolean isFocusable() {
        return true;
    }

    public int getPreferredContentHeight() {
        return this.theme.getSelectedFont().getHeight() + this.PADDING * 2;
    }

    public int getPreferredContentWidth() {
        return this.theme.getSelectedFont().stringWidth(this.text) + this.PADDING * 2;
    }

    public boolean handleKeyReleased(int key) {
        if (8 == KeyHelper.getGameAction(key)) {
            this.fireEvent();
            return true;
        }
        return false;
    }

    public boolean handlePointerReleased(int x, int y) {
        super.handlePointerReleased(x, y);
        this.fireEvent();
        return true;
    }

    protected void fireEvent() {
        if (this.handler != null) {
            Event event = new Event(4, 40001, this);
            this.handler.doCallback(event);
        }
    }
}

