package bigs;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class BigDec implements Cloneable, Comparable<BigDec>, Externalizable, IType<BigDec> {

    private final BigDecimal bi;

    public BigDec(BigDecimal bi) {
        this.bi = bi;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BigDec bigDec = (BigDec) o;
        return bi != null ? bi.equals(bigDec.bi) : bigDec.bi == null;
    }

    @Override
    public int hashCode() {
        return bi != null ? bi.hashCode() : 0;
    }

    @Override
    public String toString() {
        return bi.toString();
    }

    public BigDecimal getBi() {
        return bi;
    }

    @Override
    public BigDec clone() {
        return new BigDec(bi);
    }

    @Override
    public int compareTo(BigDec o) {
        return bi.compareTo(o.getBi());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(getBi());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readObject();
    }

    public BigInt toBigInt() {
        return new BigInt(bi.toBigInteger());
    }

    @Override
    public BigDec zero() {
        return new BigDec(BigDecimal.ZERO);
    }

    @Override
    public BigDec one() {
        return new BigDec(BigDecimal.ONE);
    }

    @Override
    public BigDec add(BigDec y) {
        return new BigDec(getBi().add(y.getBi()));
    }

    public static BigDec add(BigDec x, BigDec y) {
        return new BigDec(x.getBi().add(y.getBi()));
    }

    @Override
    public BigDec sub(BigDec y) {
        return new BigDec(getBi().subtract(y.getBi()));
    }

    public static BigDec sub(BigDec x, BigDec y) {
        return new BigDec(x.getBi().subtract(y.getBi()));
    }

    @Override
    public BigDec mult(BigDec y) {
        return new BigDec(getBi().multiply(y.getBi()));
    }

    public static BigDec mult(BigDec x, BigDec y) {
        return new BigDec(x.getBi().multiply(y.getBi()));
    }

    @Override
    public BigDec div(BigDec y) {
        return new BigDec(getBi().divide(y.getBi(), RoundingMode.HALF_UP));
    }

    public static BigDec div(BigDec x, BigDec y) {
        return new BigDec(x.getBi().divide(y.getBi(), RoundingMode.HALF_UP));
    }

    public BigDec neg() {
        return new BigDec(getBi().negate());
    }

    @Override
    public BigDec pow(int exp) {
        return new BigDec(getBi().pow(exp));
    }
}
