package rozdzial20;

import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.print.PrinterJob;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.web.HTMLEditor;
import javafx.stage.Stage;

public class Listing20_10 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            StackPane root = new StackPane();
            HTMLEditor he = new HTMLEditor();
            he.setHtmlText(
                    "<p>H<sub>2</sub>O to najcenniejszy związek chemiczny<br>Naciśnij klawisz F2, aby wydrukować.</p>");
            PrinterJob job = PrinterJob.createPrinterJob();
            EventHandler<KeyEvent> keyHandler1 = e -> {
                if (e.getEventType() == KeyEvent.KEY_RELEASED
                        && e.getCode() == KeyCode.F2) {
                    if (job != null) {
                        boolean success = job.printPage(he);
                        if (success) {
                            job.endJob();
                        }
                        he.print(job);
                    }
                }
            };
            he.addEventHandler(KeyEvent.KEY_RELEASED, keyHandler1);
            root.getChildren().add(he);
            Scene scene = new Scene(root, 500, 150);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
