package rozdzial13;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.effect.BoxBlur;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class Listing13_04 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            Pane root = new Pane();
            Text text = new Text("Shadow");
            text.setX(220);
            text.setY(100);
            text.setFill(Color.AQUAMARINE);
            //text.setStroke(Color.BLACK);
            text.setFont(Font.font(null, FontWeight.BOLD, 80));
            //efekt
            BoxBlur ds = new BoxBlur();
            text.setEffect(ds);
            //slider 1
            Slider oxslider = new Slider(0, 25, 5);
            oxslider.setLayoutX(60);
            oxslider.setLayoutY(20);
            oxslider.setMajorTickUnit(5);
            oxslider.setShowTickLabels(true);
            oxslider.setShowTickMarks(true);
            ds.widthProperty().bind(oxslider.valueProperty());
            Label oxslabel = new Label("width: ");
            oxslabel.setLabelFor(oxslider);
            oxslabel.setLayoutX(20);
            oxslabel.setLayoutY(20);
            //slider 2
            Slider oyslider = new Slider(0, 25, 5);
            oyslider.setLayoutX(60);
            oyslider.setLayoutY(60);
            oyslider.setMajorTickUnit(5);
            oyslider.setShowTickLabels(true);
            oyslider.setShowTickMarks(true);
            ds.heightProperty().bind(oyslider.valueProperty());
            Label oyslabel = new Label("height: ");
            oyslabel.setLabelFor(oyslider);
            oyslabel.setLayoutX(20);
            oyslabel.setLayoutY(60);
            //slider 3
            Slider cslider = new Slider(1, 3, 1);
            cslider.setLayoutX(80);
            cslider.setLayoutY(100);
            cslider.setMajorTickUnit(1);
            cslider.setShowTickLabels(true);
            cslider.setShowTickMarks(true);
            ds.iterationsProperty().bind(cslider.valueProperty());
            Label slabel = new Label("iterations: ");
            slabel.setLabelFor(cslider);
            slabel.setLayoutX(20);
            slabel.setLayoutY(100);
            //
            root.getChildren().addAll(oxslabel, oxslider, oyslabel, oyslider,
                    cslider, slabel, text);
            Scene scene = new Scene(root, 560, 280);
            scene.setFill(Color.WHITE);
            stage.setScene(scene);
            stage.setTitle("BoxBlur");
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
