package rozdzial11;

import javafx.application.Application;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.scene.*;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Sphere;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Translate;
import javafx.stage.Stage;

import java.io.File;
import java.io.FileInputStream;

public class Listing11_12 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        boolean supp = Platform.isSupported(ConditionalFeature.SCENE3D);
        try {
            if (supp) {
                PhongMaterial pm = new PhongMaterial();
                Image diffMap = new Image(new FileInputStream(
                        new File("src/rozdzial11/earth1.jpg")));
                pm.setDiffuseMap(diffMap);
                AmbientLight pl1 = new AmbientLight(Color.WHITE);
                Group group = new Group();
                Sphere sphere = new Sphere(100);
                sphere.setMaterial(pm);
                Rotate roty = new Rotate(35, Rotate.Y_AXIS);
                Translate trans1 = new Translate(150, 150, 100);
                sphere.getTransforms().addAll(trans1, roty);
                group.getChildren().addAll(sphere, pl1);
                Camera camera = new PerspectiveCamera(false);
                Scene sc = new Scene(group, 300, 300);
                sc.setCamera(camera);
                sc.setFill(Color.BLACK);
                stage.setScene(sc);
            } else {
                StackPane root = new StackPane();
                Label label = new Label("Brak obsługi 3D");
                root.getChildren().add(label);
                Scene sc = new Scene(root, 400, 400);
                stage.setScene(sc);
            }
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
