package rozdzial02.observ2;

import java.util.ArrayList;

public class SmokSzpiegWojskowy implements SmokSzpieg {
    private final ArrayList<Centrala> obserwatorzy;
    private float x;
    private float y;
    private int liczbaSmokow;

    public SmokSzpiegWojskowy() {
        obserwatorzy = new ArrayList<>();
    }

    @Override
    public void registerObserver(Centrala o) {
        obserwatorzy.add(o);
    }

    @Override
    public void removeObserver(Centrala o) {
        int i = obserwatorzy.indexOf(o);
        if (i >= 0) {
            obserwatorzy.remove(i);
        }
    }

    @Override
    public void notifyObservers() {
        obserwatorzy.forEach(observer -> observer.update(x, y, liczbaSmokow));
    }

    public void valueHasChanged() {
        notifyObservers();
    }

    public void setValues(float x, float y, int liczbaSmokow) {
        this.x = x;
        this.y = y;
        this.liczbaSmokow = liczbaSmokow;
        valueHasChanged();
    }

    public float getX() {
        return x;
    }

    public void setX(float x) {
        this.x = x;
        valueHasChanged();
    }

    public float getY() {
        return y;
    }

    public void setY(float y) {
        this.y = y;
        valueHasChanged();
    }

    public int getLiczbaSmokow() {
        return liczbaSmokow;
    }

    public void setLiczbaSmokow(int liczbaSmokow) {
        this.liczbaSmokow = liczbaSmokow;
        valueHasChanged();
    }
}
