package swarm;

import javax.swing.*;
import java.awt.*;

public class Insect extends JComponent implements Runnable {

    private static final long serialVersionUID = -3164260750275456552L;
    private Body body;
    private double thisX;
    private double thisY;
    private double dx = 0;
    private double dy = 0;
    private double targetX = 0;
    private double targetY = 0;
    private double oldTargetX = 0;
    private double oldTargetY = 0;
    private double randX = (Math.random() * 200.0) - 100;
    private double randY = (Math.random() * 200.0) - 100;
    private Color color;

    public Insect() {
        this(Color.BLACK);
    }

    public Insect(Color color) {
        this.color = color;
        body = new Body(1, 1, 4, 3);
        thisX = Util.randomInRange(200.0, 600.0);
        thisY = Util.randomInRange(200.0, 600.0);
        setBounds(0, 0, 6, 5);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setColor(color);
        g2.draw(body);
    }

    @Override
    public void run() {
        while (true) {
            move(Insect.this.getParent());
            this.setLocation((int) thisX, (int) thisY);
            Insect.this.getParent().repaint();
            try {
                Thread.sleep(20);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void move(Container panel) {
        Point cursor = Insect.this.getParent().getMousePosition();
        if (cursor != null) {
            targetX = cursor.getX();
            targetY = cursor.getY();
            if ((targetX == oldTargetX) && (Math.random() > 0.9)) {
                randX = (Math.random() * 100) - 50;
                randY = (Math.random() * 100) - 50;
            } else if ((targetX != oldTargetX) && (Math.random() > 0.8)) {
                randX = (Math.random() * 400) - 200;
                randY = (Math.random() * 400) - 200;
            }
            dx = targetX - thisX + randX;
            dy = targetY - thisY + randY;
            thisX = Math.round(thisX + dx / 20.0);
            thisY = Math.round(thisY + dy / 20.0);
            oldTargetX = targetX;
            oldTargetY = targetY;
        } else {
            targetX = oldTargetX;
            targetY = oldTargetY;
            if ((targetX == oldTargetX) && (Math.random() > 0.9)) {
                randX = (Math.random() * 100) - 50;
                randY = (Math.random() * 100) - 50;
            } else if ((targetX != oldTargetX) && (Math.random() > 0.8)) {
                randX = (Math.random() * 400) - 200;
                randY = (Math.random() * 400) - 200;
            }
            dx = targetX - thisX + randX;
            dy = targetY - thisY + randY;
            thisX = Math.round(thisX + dx / 20.0);
            thisY = Math.round(thisY + dy / 20.0);
            oldTargetX = targetX;
            oldTargetY = targetY;
        }
    }

    public Body getBody() {
        return body;
    }

    public void setBody(Body body) {
        this.body = body;
    }

    public double getThisX() {
        return thisX;
    }

    public void setThisX(double thisX) {
        this.thisX = thisX;
    }

    public double getThisY() {
        return thisY;
    }

    public void setThisY(double thisY) {
        this.thisY = thisY;
    }

    public double getDx() {
        return dx;
    }

    public void setDx(double dx) {
        this.dx = dx;
    }

    public double getDy() {
        return dy;
    }

    public void setDy(double dy) {
        this.dy = dy;
    }

    public double getTargetX() {
        return targetX;
    }

    public void setTargetX(double targetX) {
        this.targetX = targetX;
    }

    public double getTargetY() {
        return targetY;
    }

    public void setTargetY(double targetY) {
        this.targetY = targetY;
    }

    public double getOldTargetX() {
        return oldTargetX;
    }

    public void setOldTargetX(double oldTargetX) {
        this.oldTargetX = oldTargetX;
    }

    public double getOldTargetY() {
        return oldTargetY;
    }

    public void setOldTargetY(double oldTargetY) {
        this.oldTargetY = oldTargetY;
    }

    public double getRandX() {
        return randX;
    }

    public void setRandX(double randX) {
        this.randX = randX;
    }

    public double getRandY() {
        return randY;
    }

    public void setRandY(double randY) {
        this.randY = randY;
    }

    public Color getColor() {
        return color;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}
