package math.kombi.examples;

import math.kombi.kombi.RecurStir1;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class Stir1TableMain {
    public static void main(String[] args) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter("stirling1.html");
        } catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        if (pw != null) {
            pw.println("<!DOCTYPE html>");
            pw.println("<html>");
            pw.println("<body>");
            pw.println("<table>");
            ExecutorService es = Executors.newFixedThreadPool(326);
            Future<BigInteger> f;
            for (int n = 0; n < 26; n++) {
                pw.println("<tr>");
                for (int k = 0; k < 26; k++) {
                    if (k <= n) {
                        f = es.submit(
                                new RecurStir1(new BigInteger(String.valueOf(k)),
                                        new BigInteger(String.valueOf(n))));
                        try {
                            pw.print("<td>" + f.get() + "</td>");
                        } catch (InterruptedException | ExecutionException e) {
                            e.printStackTrace();
                        }
                    } else {
                        pw.print("<td>&nbsp;</td>");
                    }
                }
                pw.println("</tr>");
            }
            pw.println("</table>");
            pw.println("</body>");
            pw.println("</html>");
            pw.close();
            es.shutdown();
        }
    }
}
