package rozdzial28;

import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Listing28_04 extends Application {
    private Label label;

    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            VBox vbox = new VBox();
            HBox hbox = new HBox();
            Scene scene = new Scene(vbox, 200, 200);
            label = new Label("Kliknij przycisk 'Zacznij'");
            Button start = new Button("Zacznij");
            start.setOnAction(event -> task());
            Button end = new Button("Zakończ");
            end.setOnAction(e -> stage.close());
            hbox.setSpacing(5);
            hbox.getChildren().addAll(start, end);
            vbox.setSpacing(150);
            vbox.getChildren().addAll(label, hbox);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void task() {
        ExecutorService es = Executors.newSingleThreadScheduledExecutor();
        es.execute(() -> {
            int a = 46;
            System.out.println("Start");
            Instant startTime = Instant.now();
            long n = fibonacci_recurrent(a);
            Instant endTime = Instant.now();
            long time = Duration.between(startTime, endTime).toMillis();
            System.out.println("Czas wykonania: " + time + (" ms"));
            System.out.println("fibo" + a + " = " + n);
            System.out.println("Koniec");
            Platform.runLater(() -> label.setText("Twoja liczba to " + String.valueOf(n)));
        });
        if (!es.isShutdown()) {
            es.shutdown();
        }
    }

    public static long fibonacci_recurrent(int n) {
        if (n < 2) {
            return n;
        } else {
            return fibonacci_recurrent(n - 1) + fibonacci_recurrent(n - 2);
        }
    }
}
