package rozdzial20;

import javafx.scene.control.SpinnerValueFactory;

public class PrimeSpinnerValueFactory extends SpinnerValueFactory<Integer> {

    @Override
    public void increment(int steps) {
        int a = getValue();
        int b = nextPrime(a);
        setValue(b);
    }

    @Override
    public void decrement(int steps) {
        int a = getValue();
        int b = previousPrime(a);
        setValue(b);

    }

    public static int nextPrime(int n) {
        if (n < Integer.MAX_VALUE) {
            for (int j = n + 1; true; j++) {
                if (isPrime(j)) {
                    return j;
                }
            }
        }
        return n;
    }

    public static int previousPrime(int n) {
        if (n > 2) {
            for (int j = n - 1; true; j--) {
                if (isPrime(j)) {
                    return j;
                }
            }
        }
        return 2;

    }

    public static boolean isPrime(int n) {
        for (int j = 2; Math.pow(j, 2) <= n; j++) {
            if (n % j == 0) {
                return false;
            }
        }
        return true;
    }

}
