package rozdzial14;

import javafx.animation.PathTransition;
import javafx.animation.PathTransition.OrientationType;
import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Ellipse;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.util.Duration;

public class Listing14_28 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            Pane root = new Pane();
            Ellipse el = new Ellipse(275, 120, 100, 50);
            el.setFill(Color.TRANSPARENT);
            el.setStrokeWidth(1.0);
            Text text = new Text("Shadow");
            text.setStrokeWidth(1);
            text.setStroke(Color.BLACK);
            text.setFill(Color.DEEPSKYBLUE);
            text.setFont(Font.font(null, FontWeight.BOLD, 40));
            PathTransition st = new PathTransition(Duration.millis(4000), el,
                    text);
            st.setOrientation(OrientationType.NONE);
            st.setCycleCount(1);
            st.play();
            root.getChildren().addAll(text);
            Scene scene = new Scene(root, 550, 240);
            stage.setScene(scene);
            stage.setTitle("ScaleTransition");
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
